**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture
*01 Aggregate Actual
*02 short-run investment expectations
*03 long-run investment expectations
*04 by size 
*05 Deflator
*06 producing summary stats



adopath + ""


use "${data}\merged_capex.dta", clear

tsset firmid2 period


**** Aggregates
** 


***01 Aggregate Actual
*** regs with actual capex
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_`h' l(0/1).beckers_aug l(1/1).intmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_`h' l(0/1).beckers_aug l(1/1).extmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

**02 short-run investment expectations
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp1.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)


***03 long-run investment expectations
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp2.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N)

********************************************
***04 by size 
** actual investment
*** intensive margin
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_`h' l(0/1).beckers_aug l(1/1).intmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Small" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_`h' l(0/1).beckers_aug l(1/1).intmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Medium" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_med.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_`h' l(0/1).beckers_aug l(1/1).intmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Large" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 



***extensive margin
eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_`h' l(0/1).beckers_aug l(1/1).extmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Small" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_`h' l(0/1).beckers_aug l(1/1).extmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Medium" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_med.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_`h' l(0/1).beckers_aug l(1/1).extmargin_t l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Large" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

***short-run investment expectations
** intensive margin
eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Small" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp1_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Medium" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp1_med.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Large" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp1_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


*** extensive margin
eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Small" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp1_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Medium" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp1_med.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp1_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp1 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Large" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp1_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


**long-run investment expectations
**intensive margin

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Small" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp2_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Medium" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp2_med.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe intmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).intmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Large" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\intmargin_bas_cap_exp2_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


*** extensive margin

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Small" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp2_small.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 

eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Medium" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp2_med.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


eststo clear 
forv h=0/16 {
	eststo: reghdfe extmargin_t_exp2_`h' l(0/1).beckers_aug l(1/1).extmargin_t_exp2 l(1/1).gdp l(1/1).cpi l(1/1).q_turnover  if fsize=="Large" & beckers_aug!=. & l.beckers_aug!=.  , cluster (period firmid2) a(fsize_ ind qr)
}

estout * using "${results}\extmargin_bas_cap_exp2_large.csv", replace	cells(b(star) se ci_l ci_u) stats(r2 N) 


**************************************************************************

**05 Deflator

*** defining investment price deflator
***********************************************************************
gen qdate=yq(tsid,qr)
format qdate %tq
gen deflator=.
replace deflator=1.02 if period==8009
replace deflator=1.01 if period==8010
replace deflator=1.01 if period==8011
replace deflator=1.02 if period==8012
replace deflator=1.01 if period==8013
replace deflator=1.00 if period==8014
replace deflator=0.99 if period==8015
replace deflator=0.97 if period==8016
replace deflator=0.96 if period==8017
replace deflator=0.96 if period==8018
replace deflator=0.96 if period==8019
replace deflator=0.97 if period==8020
replace deflator=0.97 if period==8021
replace deflator=0.96 if period==8022
replace deflator=0.96 if period==8023
replace deflator=0.97 if period==8024
replace deflator=0.97 if period==8025
replace deflator=0.96 if period==8026
replace deflator=0.97 if period==8027
replace deflator=0.98 if period==8028
replace deflator=0.97 if period==8029
replace deflator=0.97 if period==8030
replace deflator=0.96 if period==8031
replace deflator=0.96 if period==8032
replace deflator=0.95 if period==8033
replace deflator=0.95 if period==8034
replace deflator=0.96 if period==8035
replace deflator=0.98 if period==8036
replace deflator=0.99 if period==8037
replace deflator=0.98 if period==8038
replace deflator=0.96 if period==8039
replace deflator=0.95 if period==8040
replace deflator=0.95 if period==8041
replace deflator=0.94 if period==8042
replace deflator=0.95 if period==8043
replace deflator=0.95 if period==8044
replace deflator=0.94 if period==8045
replace deflator=0.93 if period==8046
replace deflator=0.93 if period==8047
replace deflator=0.93 if period==8048
replace deflator=0.93 if period==8049
replace deflator=0.93 if period==8050
replace deflator=0.93 if period==8051
replace deflator=0.92 if period==8052
replace deflator=0.92 if period==8053
replace deflator=0.93 if period==8054
replace deflator=0.94 if period==8055
replace deflator=0.94 if period==8056
replace deflator=0.95 if period==8057
replace deflator=0.94 if period==8058
replace deflator=0.94 if period==8059
replace deflator=0.95 if period==8060
replace deflator=0.96 if period==8061
replace deflator=0.97 if period==8062
replace deflator=0.98 if period==8063
replace deflator=0.98 if period==8064
replace deflator=0.97 if period==8065
replace deflator=0.97 if period==8066
replace deflator=0.97 if period==8067
replace deflator=0.97 if period==8068
replace deflator=0.97 if period==8069
replace deflator=0.97 if period==8070
replace deflator=0.96 if period==8071
replace deflator=0.96 if period==8072
replace deflator=0.97 if period==8073
replace deflator=0.97 if period==8074
replace deflator=0.98 if period==8075
replace deflator=0.98 if period==8076
replace deflator=0.99 if period==8077
replace deflator=0.99 if period==8078
replace deflator=1.00 if period==8079
replace deflator=1.00 if period==8080
replace deflator=1.00 if period==8081
replace deflator=1.01 if period==8082
replace deflator=1.00 if period==8083
replace deflator=1.00 if period==8084






*** deflating capex
bys period: gen defcapex=cattot_capex/deflator*0.96

gen defintmargin=log(defcapex)


*deflating short- run expecttaions
bys period: gen defcapexexp1=ce1ttot_capex/deflator*0.96

** deflating long-run expectations
bys period: gen defcapexexp2=ce2ttot_capex/deflator*0.96



gen defintmargin_exp1=log(defcapexexp1)
gen defintmargin_exp2=log(defcapexexp2)


****06 producing summary stats
egen mediandefexp1=median(defcapexexp1) if defcapexexp1>0
egen mediandefexp2=median(defcapexexp2) if defcapexexp2>0

*** for Table 2
sum defcapexexp1 if defcapexexp1>0

sum defcapexexp2 if defcapexexp2>0



preserve 

egen maxcapex=max(defcapexexp1) if defcapexexp1>0
drop if defcapexexp1==maxcapex

drop maxcapex

egen maxcapex=max(defcapexexp1) if defcapexexp1>0

tabstat maxcapex, stats (mean max min)
restore

preserve 

egen maxcapex=max(defcapexexp2) if defcapexexp2>0
drop if defcapexexp2==maxcapex

drop maxcapex

egen maxcapex=max(defcapexexp2) if defcapexexp2>0

tabstat maxcapex, stats (mean max min)
restore

***** Table A1 and A2 in appendix
tabstat extmargin_t, by (fsize) stat(N mean SD min max)
tabstat extmargin_t_exp1, by (fsize) stat(N mean SD min max)
tabstat extmargin_t_exp2, by (fsize) stat(N mean SD min max)




egen medianbas=median(cattot_capex) if cattot_capex>0
egen mediandef=median(defcapex) if defcapex>0


preserve 

egen maxcapex=max(defcapex) if defcapex>0
drop if defcapex==maxcapex

drop maxcapex

egen maxcapex=max(defcapex) if defcapex>0

tabstat maxcapex, stats (mean max min)
restore

preserve 
collapse (count) number_of_firms=firmid2, by (tsid)

tabstat number_of_firms, stats (N mean min max) by (tsid)
restore






































